//=============================================================================
// Rocket.
//=============================================================================
class CarnageRocket extends DeusExProjectile;

var float mpBlastRadius;

var ParticleGenerator fireGen;
var ParticleGenerator smokeGen;


simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ShockRing ring;
   local SphereEffect sphere;
	local ExplosionLight light;
   local AnimatedSprite expeffect;

   if (DamageType == 'Exploded')
   {
	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
   if (light != None)
      light.RemoteRole = ROLE_None;

	if (blastRadius < 128)
	{
		expeffect = Spawn(class'ExplosionSmall',,, HitLocation);
		light.size = 2;
	}
	else if (blastRadius < 256)
	{
		expeffect = Spawn(class'ExplosionMedium',,, HitLocation);
		light.size = 4;
	}
	else
	{
		expeffect = Spawn(class'ExplosionLarge',,, HitLocation);
		light.size = 8;
	}

   if (expeffect != None)
      expeffect.RemoteRole = ROLE_None;

	// draw a pretty shock ring
   // For nano defense we are doing something else.
   if ((!bAggressiveExploded) || (Level.NetMode == NM_Standalone))
   {
      ring = Spawn(class'ShockRing',,, HitLocation, rot(16384,0,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }
      ring = Spawn(class'ShockRing',,, HitLocation, rot(0,0,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }
      ring = Spawn(class'ShockRing',,, HitLocation, rot(0,16384,0));
      if (ring != None)
      {
         ring.RemoteRole = ROLE_None;
         ring.size = blastRadius / 32.0;
      }
   }
   else
   {
      sphere = Spawn(class'SphereEffect',,, HitLocation, rot(16384,0,0));
      if (sphere != None)
      {
         sphere.RemoteRole = ROLE_None;
         sphere.size = blastRadius / 32.0;
      }
      sphere = Spawn(class'SphereEffect',,, HitLocation, rot(0,0,0));
      if (sphere != None)
      {
         sphere.RemoteRole = ROLE_None;
         sphere.size = blastRadius / 32.0;
      }
      sphere = Spawn(class'SphereEffect',,, HitLocation, rot(0,16384,0));
      if (sphere != None)
      {
         sphere.RemoteRole = ROLE_None;
         sphere.size = blastRadius / 32.0;
      }
   }
 }

	if (DamageType == 'Flamed') Spawn(Class'FireSplashLarge',,, HitLocation);
	if (DamageType == 'Shocked') Spawn(Class'ShockSplashLarge',,, HitLocation);
	if (DamageType == 'Acid') Spawn(Class'AcidSplashLarge',,, HitLocation);
	
	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
}

function PostBeginPlay()
{
	Super.PostBeginPlay();

   if (Level.NetMode == NM_DedicatedServer)
      return;
   
   SpawnRocketEffects();
}

simulated function PostNetBeginPlay()
{
   Super.PostNetBeginPlay();
   
   if (Role != ROLE_Authority)
      SpawnRocketEffects();
}

simulated function SpawnRocketEffects()
{
	fireGen = Spawn(class'ParticleGenerator', Self);
	if (fireGen != None)
	{
      fireGen.RemoteRole = ROLE_None;
		fireGen.particleTexture = Texture'Effects.Fire.Fireball1';
		fireGen.particleDrawScale = 0.1;
		fireGen.checkTime = 0.01;
		fireGen.riseRate = 0.0;
		fireGen.ejectSpeed = 0.0;
		fireGen.particleLifeSpan = 0.1;
		fireGen.bRandomEject = True;
		fireGen.SetBase(Self);
	}
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
      smokeGen.RemoteRole = ROLE_None;
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.3;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();
	if (fireGen != None)
		fireGen.DelayedDestroy();

	Super.Destroyed();
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ( Level.NetMode != NM_Standalone ) && (Class == Class'Rocket') )
	{
		blastRadius = mpBlastRadius;
      speed = 2000.0000;
      //SetTimer(5,false);
		SoundRadius = 64;
	}
}

simulated function Timer()
{
   if (Level.NetMode != NM_Standalone)
   {   
      Explode(Location, vect(0,0,1));
   }
}

function ApplyParentStats(int Power, string Threat)
{
 Damage = Power;
  
 if (Threat ~= "Acid") DamageType = 'Acid';
 if (Threat ~= "Fire") DamageType = 'Flamed';
 if (Threat ~= "Shock") DamageType = 'Shocked';


 if (DamageType == 'Explosive')
 {
  ImpactSound = Sound'LargeExplosion1';
 }
 if (DamageType == 'Flamed' || DamageType == 'Acid')
 {
  ImpactSound = Sound'SmallExplosion2';
 }
 if (DamageType == 'Shocked')
 {
  ImpactSound = Sound'EMPGrenadeExplode';
 }
}

function PlayImpactSound()
{
	local float rad;

	if ((Level.NetMode == NM_Standalone) || (Level.NetMode == NM_ListenServer) || (Level.NetMode == NM_DedicatedServer))
	{
		rad = Max(blastRadius*4, 1024);
		PlaySound(ImpactSound, SLOT_None, 2.0,, rad);
	}
}

state Exploding
{
	ignores ProcessTouch, HitWall, Explode;

   function DamageRing()
   {
		local Pawn apawn;
		local float damageRadius;
		local Vector dist;

		if ( Level.NetMode != NM_Standalone )
		{
			damageRadius = (blastRadius / gradualHurtSteps) * gradualHurtCounter;

			for ( apawn = Level.PawnList; apawn != None; apawn = apawn.nextPawn )
			{
				if ( apawn.IsA('DeusExPlayer') )
				{
					dist = apawn.Location - Location;
					if ( VSize(dist) < damageRadius )
					{
						if ( gradualHurtCounter <= 2 )
						{
							if ( apawn.FastTrace( apawn.Location, Location ))
								DeusExPlayer(apawn).myProjKiller = Self;
						}
						else
							DeusExPlayer(apawn).myProjKiller = Self;
					}
				}
			}
		}
      //DEUS_EX AMSD Ignore Line of Sight on the lowest radius check, only in multiplayer
		HurtRadius
		(
			(2 * Damage) / gradualHurtSteps,
			(blastRadius / gradualHurtSteps) * gradualHurtCounter,
			damageType,
			MomentumTransfer / gradualHurtSteps,
			Location,
         ((gradualHurtCounter <= 2) && (Level.NetMode != NM_Standalone))
		);
   }

	function Timer()
	{
		gradualHurtCounter++;
      DamageRing();
		if (gradualHurtCounter >= gradualHurtSteps)
			Destroy();
	}

Begin:
	// stagger the HurtRadius outward using Timer()
	// do five separate blast rings increasing in size
	gradualHurtCounter = 1;
	gradualHurtSteps = 5;
	Velocity = vect(0,0,0);
	bHidden = True;
	LightType = LT_None;
	SetCollision(False, False, False);
   DamageRing();

	if (DamageType == 'Shocked') HurtRadius(Damage, BlastRadius, 'EMP', 1, Location);
        if (DamagetYpe == 'Acid') ApplyAcid();

	SetTimer(0.25/float(gradualHurtSteps), True);
}

function ApplyAcid()
{
 local AcidMold M;
 local Actor A;
 
 forEach RadiusActors(class'Actor', A, BlastRadius)
 {
  if (A.IsA('DeusExDecoration') || A.IsA('DeusExCarcass') || A.IsA('ScriptedPawn'))
  {
   M = Spawn(class'AcidMold',A,,Location);
   M.Moldee = A;
  }
 }
}

defaultproperties
{
     mpBlastRadius=192.000000
     bExplodes=True
     bBlood=True
     bDebris=True
     blastRadius=192.000000
     DamageType=exploded
     AccurateRange=14400
     maxRange=24000
     bTracking=True
     ItemName="Carnage Rocket"
     ItemArticle="a"
     speed=2000.000000
     MaxSpeed=3000.000000
     Damage=300.000000
     MomentumTransfer=10000
     SpawnSound=Sound'DeusExSounds.Weapons.GEPGunFire'
     ImpactSound=Sound'DeusExSounds.Generic.SmallExplosion1'
     ExplosionDecal=Class'DeusEx.ScorchMark'
     Mesh=LodMesh'DeusExItems.Rocket'
     DrawScale=0.250000
     SoundRadius=16
     SoundVolume=224
     AmbientSound=Sound'DeusExSounds.Special.RocketLoop'
     RotationRate=(Pitch=32768,Yaw=32768)
}
